SET NOCOUNT ON;
DECLARE @CD_EMP INT
DECLARE @CD_ARV_MERC_CATEG INT
DECLARE @DS_ARV_MERC_CATEG VARCHAR(150)

DECLARE CCategoria CURSOR FAST_FORWARD FOR
select
	DISTINCT CD_EMP,
	CD_ARV_MERC_CATEG,
	DS_ARV_MERC_CATEG
from
	EST_ARV_MERC_CATEGORIA

OPEN CCategoria
FETCH NEXT FROM CCategoria INTO @CD_EMP,@CD_ARV_MERC_CATEG,@DS_ARV_MERC_CATEG;

WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT '  Categoria ' + CONVERT(VARCHAR(10), @CD_ARV_MERC_CATEG)  + ' - ' + CONVERT(VARCHAR(100), @DS_ARV_MERC_CATEG) +  '(' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
		IF NOT EXISTS (SELECT
						CD_ARV_MERC_CATEG_SUB
					FROM
						EST_ARV_MERC_CATEGORIA_SUB
					WHERE
						CD_EMP=@CD_EMP
						AND CD_ARV_MERC_CATEG = @CD_ARV_MERC_CATEG
						AND CD_ARV_MERC_CATEG_SUB=0)
		BEGIN
		INSERT INTO EST_ARV_MERC_CATEGORIA_SUB
		(CD_EMP,
		CD_ARV_MERC_CATEG_SUB,
		CD_ARV_MERC_CATEG,
		DS_ARV_MERC_CATEG_SUB,
		DT_CAD,
		CD_USU,
		DT_ULT_ALT)
		SELECT	
			@CD_EMP,
			0,
			@CD_ARV_MERC_CATEG,
			'NAO DEFINIDO',
			GETDATE(),
			1,
			NULL
		END	
FETCH NEXT FROM CCategoria INTO @CD_EMP,@CD_ARV_MERC_CATEG,@DS_ARV_MERC_CATEG;
END 

CLOSE CCategoria
DEALLOCATE CCategoria